package gov.va.genisis2.ts.fuseki;

import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.springframework.stereotype.Component;

/**
 * @author PII
 *
 */
@Component
public class FusekiClient {

	private long queryConnectionTimeout = 5000L;
	private long queryReadTimeout = 5000L;

	public ResultSet performSelectQuery(QueryExecution qe, String sparqlEndPoint) {
		qe.setTimeout(queryReadTimeout, queryConnectionTimeout);
		return qe.execSelect();
	}

	public void performUpdate(String command, String sparqlEndPoint) {
		performUpdate(UpdateFactory.create(command), sparqlEndPoint);
	}

	public void performUpdate(UpdateRequest request, String sparqlEndPoint) {
		UpdateProcessor proc = UpdateExecutionFactory.createRemote(request, sparqlEndPoint);
		proc.execute();
	}

	/**
	 * Returns true or false if the given query string is containd in the triple
	 * store Query should be in the format of ASK {?s ?p ?o}
	 * 
	 * @param query
	 * @param sparqlEndpoint
	 * @return
	 * @throws Exception
	 */
	public boolean performAsk(String query, String sparqlEndpoint) throws Exception {
		QueryExecution qe = QueryExecutionFactory.sparqlService(sparqlEndpoint, query);
		Boolean exists = null;
		try {
			exists = qe.execAsk();
		} catch (Exception e) {
			throw new Exception("Error trying to exceute command: " + e);
		} finally {
			if (qe != null)
				qe.close();
		}
		return exists;
	}
}
